
#### **1. Overview of Cisco Secure Endpoint Architecture**

- The **AMP architecture** integrates various security components, including:
    - Cisco Secure Firewall
    - Cisco Secure Email Security
    - Cisco Secure Web
- Centralized threat detection powered by the **Cisco Secure Endpoint Cloud** and **Talos Threat Intelligence**.
- Unknown files submitted to Cisco Secure Endpoint Cloud can be further analyzed in the **Cisco Secure Malware Analytics** sandbox.
- Convictions and analysis results are shared globally with all AMP components.

---

#### **2. Key Components of Cisco Secure Endpoint Solution**

- **Cisco Secure Endpoint Cloud**:
    
    - Hosts detection and analytics engines.
    - Shares file disposition updates with connected components.
- **Cisco Secure Malware Analytics Cloud**:
    
    - Sandboxing solution for deep file analysis.
    - Updates file dispositions in the Cisco Secure Endpoint Cloud.
- **Cisco Secure Endpoint Connectors** (Endpoint Agents):
    
    - Installed on endpoint devices to communicate with the cloud and enforce policies.
    - Connector Types:
        - **Windows Connector**: Supports Windows 10/11 and Windows Server. Uses **TETRA** for offline detection.
        - **macOS Connector**: Supports macOS 11.3 or later. Uses **ClamAV** for offline detection.
        - **Linux Connector**: Supports Red Hat/CentOS 6, 7, 8, and 9. Uses **ClamAV** for offline detection.
        - **Android Connector**: Detects mobile malware on Android devices.
        - **Clarity for iOS**: Detects mobile malware and integrates with Cisco Umbrella on Apple devices.
- **Cisco Secure Endpoint Management Console**:
    
    - Centralized web-based management for endpoints.
    - Deployment Options:
        - **Public Cloud**: Managed by Cisco and hosted on the internet (most common).
        - **Private Cloud**: Managed internally using the Cisco Secure Endpoint Private Cloud appliance.

---

#### **3. How Cisco Secure Endpoint Operates**

- **File Hashing and Verdict Retrieval**:
    
    - When a file is moved, executed, or copied:
        - The connector calculates the file’s hash and queries the Cisco Secure Endpoint Cloud for a verdict.
        - Verdicts can be **clean**, **malware**, or **unknown**.
- **Dynamic Analysis of Unknown Files**:
    
    - If the verdict is unknown:
        - The file can be sent to the Cisco Secure Malware Analytics sandbox for analysis.
        - Files can also be manually submitted by users via the console.
- **Retrospective Events**:
    
    - Once a verdict is issued by the Cisco Secure Malware Analytics sandbox:
        - The Cisco Secure Endpoint Cloud updates all components globally about the new file disposition.

---

#### **4. Installation and Key Components of the Connector**

- **Connector Installation**:
    
    - Includes all software and policies required for endpoint communication with the cloud.
- **Installed Components**:
    
    - **Kernel Modules**:
        - **Immunet Protect Driver**: Monitors file actions (move, copy, execute).
        - **Immunet Network Driver**: Associates network traffic with specific applications for inspection.
        - **Immunet Self-Protect Driver**: Prevents tampering with the connector installation.
    - **Cisco Secure Client User Interface**: User interface module for endpoint management.
    - **sfc.exe**: Manages cloud communications, including file hashes and feature prints.

---

#### **5. Cisco Secure Endpoint Use Cases**

- **Deployment**:
    
    - Install the Cisco Secure Endpoint connector on endpoint devices.
    - Configure policies and monitor endpoints via the public or private Cisco Secure Endpoint Management Console.
- **Cloud Locations**:
    
    - Cisco Secure Endpoint Cloud operates in multiple regions:
        - United States
        - Europe
        - Asia Pacific, Japan, and China
    - Intelligence is centralized in the Cisco Secure Endpoint Cloud, regardless of deployment type (public or private).

---

#### **6. Key Takeaways**

- **Centralized Threat Intelligence**:
    - The Cisco Secure Endpoint Cloud serves as the central hub for threat detection and intelligence sharing.
- **Global Integration**:
    - File analysis and convictions are shared across all AMP components worldwide.
- **Comprehensive Endpoint Security**:
    - Combines cloud-based intelligence, dynamic sandboxing, and endpoint-level enforcement.


